package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait ExpirationStatus {
  def unwrap: software.amazon.awssdk.services.s3control.model.ExpirationStatus
}
object ExpirationStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.ExpirationStatus
  ): zio.aws.s3control.model.ExpirationStatus = value match {
    case software.amazon.awssdk.services.s3control.model.ExpirationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.ExpirationStatus.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.s3control.model.ExpirationStatus.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.ExpirationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ExpirationStatus =
      software.amazon.awssdk.services.s3control.model.ExpirationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.s3control.model.ExpirationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ExpirationStatus =
      software.amazon.awssdk.services.s3control.model.ExpirationStatus.ENABLED
  }
  case object Disabled extends zio.aws.s3control.model.ExpirationStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.ExpirationStatus =
      software.amazon.awssdk.services.s3control.model.ExpirationStatus.DISABLED
  }
}
