package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{
  ObjectLambdaAccessPointName,
  AccountId
}
import scala.jdk.CollectionConverters._
final case class GetAccessPointForObjectLambdaRequest(
    accountId: AccountId,
    name: ObjectLambdaAccessPointName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaRequest = {
    import GetAccessPointForObjectLambdaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .name(ObjectLambdaAccessPointName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetAccessPointForObjectLambdaRequest.ReadOnly =
    zio.aws.s3control.model.GetAccessPointForObjectLambdaRequest
      .wrap(buildAwsValue())
}
object GetAccessPointForObjectLambdaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.GetAccessPointForObjectLambdaRequest =
      zio.aws.s3control.model
        .GetAccessPointForObjectLambdaRequest(accountId, name)
    def accountId: AccountId
    def name: ObjectLambdaAccessPointName
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getName: ZIO[Any, Nothing, ObjectLambdaAccessPointName] =
      ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaRequest
  ) extends zio.aws.s3control.model.GetAccessPointForObjectLambdaRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val name: ObjectLambdaAccessPointName =
      zio.aws.s3control.model.primitives
        .ObjectLambdaAccessPointName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaRequest
  ): zio.aws.s3control.model.GetAccessPointForObjectLambdaRequest.ReadOnly =
    new Wrapper(impl)
}
