package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBucketLifecycleConfigurationResponse(
    rules: Optional[Iterable[zio.aws.s3control.model.LifecycleRule]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetBucketLifecycleConfigurationResponse = {
    import GetBucketLifecycleConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetBucketLifecycleConfigurationResponse
      .builder()
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetBucketLifecycleConfigurationResponse.ReadOnly =
    zio.aws.s3control.model.GetBucketLifecycleConfigurationResponse
      .wrap(buildAwsValue())
}
object GetBucketLifecycleConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetBucketLifecycleConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.GetBucketLifecycleConfigurationResponse =
      zio.aws.s3control.model.GetBucketLifecycleConfigurationResponse(
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def rules: Optional[List[zio.aws.s3control.model.LifecycleRule.ReadOnly]]
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.LifecycleRule.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetBucketLifecycleConfigurationResponse
  ) extends zio.aws.s3control.model.GetBucketLifecycleConfigurationResponse.ReadOnly {
    override val rules
        : Optional[List[zio.aws.s3control.model.LifecycleRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3control.model.LifecycleRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetBucketLifecycleConfigurationResponse
  ): zio.aws.s3control.model.GetBucketLifecycleConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
