package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{BucketName, AccountId}
import scala.jdk.CollectionConverters._
final case class GetBucketReplicationRequest(
    accountId: AccountId,
    bucket: BucketName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetBucketReplicationRequest = {
    import GetBucketReplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetBucketReplicationRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.GetBucketReplicationRequest.ReadOnly =
    zio.aws.s3control.model.GetBucketReplicationRequest.wrap(buildAwsValue())
}
object GetBucketReplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetBucketReplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GetBucketReplicationRequest =
      zio.aws.s3control.model.GetBucketReplicationRequest(accountId, bucket)
    def accountId: AccountId
    def bucket: BucketName
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetBucketReplicationRequest
  ) extends zio.aws.s3control.model.GetBucketReplicationRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val bucket: BucketName =
      zio.aws.s3control.model.primitives.BucketName(impl.bucket())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetBucketReplicationRequest
  ): zio.aws.s3control.model.GetBucketReplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
