package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{BucketName, AccountId}
import scala.jdk.CollectionConverters._
final case class GetBucketTaggingRequest(
    accountId: AccountId,
    bucket: BucketName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetBucketTaggingRequest = {
    import GetBucketTaggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetBucketTaggingRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.GetBucketTaggingRequest.ReadOnly =
    zio.aws.s3control.model.GetBucketTaggingRequest.wrap(buildAwsValue())
}
object GetBucketTaggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetBucketTaggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GetBucketTaggingRequest =
      zio.aws.s3control.model.GetBucketTaggingRequest(accountId, bucket)
    def accountId: AccountId
    def bucket: BucketName
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetBucketTaggingRequest
  ) extends zio.aws.s3control.model.GetBucketTaggingRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val bucket: BucketName =
      zio.aws.s3control.model.primitives.BucketName(impl.bucket())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetBucketTaggingRequest
  ): zio.aws.s3control.model.GetBucketTaggingRequest.ReadOnly = new Wrapper(
    impl
  )
}
