package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait JobManifestFormat {
  def unwrap: software.amazon.awssdk.services.s3control.model.JobManifestFormat
}
object JobManifestFormat {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.JobManifestFormat
  ): zio.aws.s3control.model.JobManifestFormat = value match {
    case software.amazon.awssdk.services.s3control.model.JobManifestFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.JobManifestFormat.S3_BATCH_OPERATIONS_CSV_20180820 =>
      val r = S3BatchOperations_CSV_20180820
      r
    case software.amazon.awssdk.services.s3control.model.JobManifestFormat.S3_INVENTORY_REPORT_CSV_20161130 =>
      val r = S3InventoryReport_CSV_20161130
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.JobManifestFormat {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobManifestFormat =
      software.amazon.awssdk.services.s3control.model.JobManifestFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object S3BatchOperations_CSV_20180820
      extends zio.aws.s3control.model.JobManifestFormat {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobManifestFormat =
      software.amazon.awssdk.services.s3control.model.JobManifestFormat.S3_BATCH_OPERATIONS_CSV_20180820
  }
  case object S3InventoryReport_CSV_20161130
      extends zio.aws.s3control.model.JobManifestFormat {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobManifestFormat =
      software.amazon.awssdk.services.s3control.model.JobManifestFormat.S3_INVENTORY_REPORT_CSV_20161130
  }
}
