package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class JobManifestSpec(
    format: zio.aws.s3control.model.JobManifestFormat,
    fields: Optional[Iterable[zio.aws.s3control.model.JobManifestFieldName]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.JobManifestSpec = {
    import JobManifestSpec.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.JobManifestSpec
      .builder()
      .format(format.unwrap)
      .optionallyWith(
        fields.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.fieldsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.JobManifestSpec.ReadOnly =
    zio.aws.s3control.model.JobManifestSpec.wrap(buildAwsValue())
}
object JobManifestSpec {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.JobManifestSpec
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.JobManifestSpec =
      zio.aws.s3control.model
        .JobManifestSpec(format, fields.map(value => value))
    def format: zio.aws.s3control.model.JobManifestFormat
    def fields: Optional[List[zio.aws.s3control.model.JobManifestFieldName]]
    def getFormat
        : ZIO[Any, Nothing, zio.aws.s3control.model.JobManifestFormat] =
      ZIO.succeed(format)
    def getFields: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.JobManifestFieldName
    ]] = AwsError.unwrapOptionField("fields", fields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.JobManifestSpec
  ) extends zio.aws.s3control.model.JobManifestSpec.ReadOnly {
    override val format: zio.aws.s3control.model.JobManifestFormat =
      zio.aws.s3control.model.JobManifestFormat.wrap(impl.format())
    override val fields
        : Optional[List[zio.aws.s3control.model.JobManifestFieldName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3control.model.JobManifestFieldName.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.JobManifestSpec
  ): zio.aws.s3control.model.JobManifestSpec.ReadOnly = new Wrapper(impl)
}
