package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{
  ReportPrefixString,
  S3BucketArnString
}
import scala.jdk.CollectionConverters._
final case class JobReport(
    bucket: Optional[S3BucketArnString] = Optional.Absent,
    format: Optional[zio.aws.s3control.model.JobReportFormat] = Optional.Absent,
    enabled: Boolean,
    prefix: Optional[ReportPrefixString] = Optional.Absent,
    reportScope: Optional[zio.aws.s3control.model.JobReportScope] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.JobReport = {
    import JobReport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.JobReport
      .builder()
      .optionallyWith(
        bucket.map(value => S3BucketArnString.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(
        prefix.map(value => ReportPrefixString.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(reportScope.map(value => value.unwrap))(_.reportScope)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.JobReport.ReadOnly =
    zio.aws.s3control.model.JobReport.wrap(buildAwsValue())
}
object JobReport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.JobReport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.JobReport =
      zio.aws.s3control.model.JobReport(
        bucket.map(value => value),
        format.map(value => value),
        enabled,
        prefix.map(value => value),
        reportScope.map(value => value)
      )
    def bucket: Optional[S3BucketArnString]
    def format: Optional[zio.aws.s3control.model.JobReportFormat]
    def enabled: Boolean
    def prefix: Optional[ReportPrefixString]
    def reportScope: Optional[zio.aws.s3control.model.JobReportScope]
    def getBucket: ZIO[Any, AwsError, S3BucketArnString] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getFormat: ZIO[Any, AwsError, zio.aws.s3control.model.JobReportFormat] =
      AwsError.unwrapOptionField("format", format)
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getPrefix: ZIO[Any, AwsError, ReportPrefixString] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getReportScope
        : ZIO[Any, AwsError, zio.aws.s3control.model.JobReportScope] =
      AwsError.unwrapOptionField("reportScope", reportScope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.JobReport
  ) extends zio.aws.s3control.model.JobReport.ReadOnly {
    override val bucket: Optional[S3BucketArnString] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.s3control.model.primitives.S3BucketArnString(value))
    override val format: Optional[zio.aws.s3control.model.JobReportFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.s3control.model.JobReportFormat.wrap(value))
    override val enabled: Boolean = impl.enabled(): Boolean
    override val prefix: Optional[ReportPrefixString] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value =>
        zio.aws.s3control.model.primitives.ReportPrefixString(value)
      )
    override val reportScope: Optional[zio.aws.s3control.model.JobReportScope] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportScope())
        .map(value => zio.aws.s3control.model.JobReportScope.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.JobReport
  ): zio.aws.s3control.model.JobReport.ReadOnly = new Wrapper(impl)
}
