package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait JobReportFormat {
  def unwrap: software.amazon.awssdk.services.s3control.model.JobReportFormat
}
object JobReportFormat {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.JobReportFormat
  ): zio.aws.s3control.model.JobReportFormat = value match {
    case software.amazon.awssdk.services.s3control.model.JobReportFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.JobReportFormat.REPORT_CSV_20180820 =>
      val r = Report_CSV_20180820
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.JobReportFormat {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobReportFormat =
      software.amazon.awssdk.services.s3control.model.JobReportFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object Report_CSV_20180820
      extends zio.aws.s3control.model.JobReportFormat {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.JobReportFormat =
      software.amazon.awssdk.services.s3control.model.JobReportFormat.REPORT_CSV_20180820
  }
}
