package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.JobTimeInStateSeconds
import scala.jdk.CollectionConverters._
final case class JobTimers(
    elapsedTimeInActiveSeconds: Optional[JobTimeInStateSeconds] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.JobTimers = {
    import JobTimers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.JobTimers
      .builder()
      .optionallyWith(
        elapsedTimeInActiveSeconds.map(value =>
          JobTimeInStateSeconds.unwrap(value): java.lang.Long
        )
      )(_.elapsedTimeInActiveSeconds)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.JobTimers.ReadOnly =
    zio.aws.s3control.model.JobTimers.wrap(buildAwsValue())
}
object JobTimers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.JobTimers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.JobTimers = zio.aws.s3control.model
      .JobTimers(elapsedTimeInActiveSeconds.map(value => value))
    def elapsedTimeInActiveSeconds: Optional[JobTimeInStateSeconds]
    def getElapsedTimeInActiveSeconds
        : ZIO[Any, AwsError, JobTimeInStateSeconds] =
      AwsError.unwrapOptionField(
        "elapsedTimeInActiveSeconds",
        elapsedTimeInActiveSeconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.JobTimers
  ) extends zio.aws.s3control.model.JobTimers.ReadOnly {
    override val elapsedTimeInActiveSeconds: Optional[JobTimeInStateSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elapsedTimeInActiveSeconds())
        .map(value =>
          zio.aws.s3control.model.primitives.JobTimeInStateSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.JobTimers
  ): zio.aws.s3control.model.JobTimers.ReadOnly = new Wrapper(impl)
}
