package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LifecycleConfiguration(
    rules: Optional[Iterable[zio.aws.s3control.model.LifecycleRule]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.LifecycleConfiguration = {
    import LifecycleConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.LifecycleConfiguration
      .builder()
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.LifecycleConfiguration.ReadOnly =
    zio.aws.s3control.model.LifecycleConfiguration.wrap(buildAwsValue())
}
object LifecycleConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.LifecycleConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.LifecycleConfiguration =
      zio.aws.s3control.model.LifecycleConfiguration(
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def rules: Optional[List[zio.aws.s3control.model.LifecycleRule.ReadOnly]]
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.s3control.model.LifecycleRule.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.LifecycleConfiguration
  ) extends zio.aws.s3control.model.LifecycleConfiguration.ReadOnly {
    override val rules
        : Optional[List[zio.aws.s3control.model.LifecycleRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3control.model.LifecycleRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.LifecycleConfiguration
  ): zio.aws.s3control.model.LifecycleConfiguration.ReadOnly = new Wrapper(impl)
}
