package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MultiRegionAccessPointPolicyDocument(
    established: Optional[
      zio.aws.s3control.model.EstablishedMultiRegionAccessPointPolicy
    ] = Optional.Absent,
    proposed: Optional[
      zio.aws.s3control.model.ProposedMultiRegionAccessPointPolicy
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointPolicyDocument = {
    import MultiRegionAccessPointPolicyDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointPolicyDocument
      .builder()
      .optionallyWith(established.map(value => value.buildAwsValue()))(
        _.established
      )
      .optionallyWith(proposed.map(value => value.buildAwsValue()))(_.proposed)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.MultiRegionAccessPointPolicyDocument.ReadOnly =
    zio.aws.s3control.model.MultiRegionAccessPointPolicyDocument
      .wrap(buildAwsValue())
}
object MultiRegionAccessPointPolicyDocument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointPolicyDocument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.MultiRegionAccessPointPolicyDocument =
      zio.aws.s3control.model.MultiRegionAccessPointPolicyDocument(
        established.map(value => value.asEditable),
        proposed.map(value => value.asEditable)
      )
    def established: Optional[
      zio.aws.s3control.model.EstablishedMultiRegionAccessPointPolicy.ReadOnly
    ]
    def proposed: Optional[
      zio.aws.s3control.model.ProposedMultiRegionAccessPointPolicy.ReadOnly
    ]
    def getEstablished: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.EstablishedMultiRegionAccessPointPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("established", established)
    def getProposed: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.ProposedMultiRegionAccessPointPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("proposed", proposed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointPolicyDocument
  ) extends zio.aws.s3control.model.MultiRegionAccessPointPolicyDocument.ReadOnly {
    override val established: Optional[
      zio.aws.s3control.model.EstablishedMultiRegionAccessPointPolicy.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.established())
      .map(value =>
        zio.aws.s3control.model.EstablishedMultiRegionAccessPointPolicy
          .wrap(value)
      )
    override val proposed: Optional[
      zio.aws.s3control.model.ProposedMultiRegionAccessPointPolicy.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.proposed())
      .map(value =>
        zio.aws.s3control.model.ProposedMultiRegionAccessPointPolicy.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.MultiRegionAccessPointPolicyDocument
  ): zio.aws.s3control.model.MultiRegionAccessPointPolicyDocument.ReadOnly =
    new Wrapper(impl)
}
