package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PrefixLevel(
    storageMetrics: zio.aws.s3control.model.PrefixLevelStorageMetrics
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.PrefixLevel = {
    import PrefixLevel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.PrefixLevel
      .builder()
      .storageMetrics(storageMetrics.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.PrefixLevel.ReadOnly =
    zio.aws.s3control.model.PrefixLevel.wrap(buildAwsValue())
}
object PrefixLevel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.PrefixLevel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.PrefixLevel =
      zio.aws.s3control.model.PrefixLevel(storageMetrics.asEditable)
    def storageMetrics
        : zio.aws.s3control.model.PrefixLevelStorageMetrics.ReadOnly
    def getStorageMetrics: ZIO[
      Any,
      Nothing,
      zio.aws.s3control.model.PrefixLevelStorageMetrics.ReadOnly
    ] = ZIO.succeed(storageMetrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.PrefixLevel
  ) extends zio.aws.s3control.model.PrefixLevel.ReadOnly {
    override val storageMetrics
        : zio.aws.s3control.model.PrefixLevelStorageMetrics.ReadOnly =
      zio.aws.s3control.model.PrefixLevelStorageMetrics
        .wrap(impl.storageMetrics())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.PrefixLevel
  ): zio.aws.s3control.model.PrefixLevel.ReadOnly = new Wrapper(impl)
}
