package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{
  ObjectLambdaAccessPointName,
  AccountId
}
import scala.jdk.CollectionConverters._
final case class PutAccessPointConfigurationForObjectLambdaRequest(
    accountId: AccountId,
    name: ObjectLambdaAccessPointName,
    configuration: zio.aws.s3control.model.ObjectLambdaConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest = {
    import PutAccessPointConfigurationForObjectLambdaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .name(ObjectLambdaAccessPointName.unwrap(name): java.lang.String)
      .configuration(configuration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest.ReadOnly =
    zio.aws.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest
      .wrap(buildAwsValue())
}
object PutAccessPointConfigurationForObjectLambdaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest =
      zio.aws.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest(
        accountId,
        name,
        configuration.asEditable
      )
    def accountId: AccountId
    def name: ObjectLambdaAccessPointName
    def configuration
        : zio.aws.s3control.model.ObjectLambdaConfiguration.ReadOnly
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getName: ZIO[Any, Nothing, ObjectLambdaAccessPointName] =
      ZIO.succeed(name)
    def getConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.s3control.model.ObjectLambdaConfiguration.ReadOnly
    ] = ZIO.succeed(configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest
  ) extends zio.aws.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val name: ObjectLambdaAccessPointName =
      zio.aws.s3control.model.primitives
        .ObjectLambdaAccessPointName(impl.name())
    override val configuration
        : zio.aws.s3control.model.ObjectLambdaConfiguration.ReadOnly =
      zio.aws.s3control.model.ObjectLambdaConfiguration
        .wrap(impl.configuration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest
  ): zio.aws.s3control.model.PutAccessPointConfigurationForObjectLambdaRequest.ReadOnly =
    new Wrapper(impl)
}
