package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{
  ObjectLambdaPolicy,
  ObjectLambdaAccessPointName,
  AccountId
}
import scala.jdk.CollectionConverters._
final case class PutAccessPointPolicyForObjectLambdaRequest(
    accountId: AccountId,
    name: ObjectLambdaAccessPointName,
    policy: ObjectLambdaPolicy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyForObjectLambdaRequest = {
    import PutAccessPointPolicyForObjectLambdaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyForObjectLambdaRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .name(ObjectLambdaAccessPointName.unwrap(name): java.lang.String)
      .policy(ObjectLambdaPolicy.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.PutAccessPointPolicyForObjectLambdaRequest.ReadOnly =
    zio.aws.s3control.model.PutAccessPointPolicyForObjectLambdaRequest
      .wrap(buildAwsValue())
}
object PutAccessPointPolicyForObjectLambdaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyForObjectLambdaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.PutAccessPointPolicyForObjectLambdaRequest =
      zio.aws.s3control.model
        .PutAccessPointPolicyForObjectLambdaRequest(accountId, name, policy)
    def accountId: AccountId
    def name: ObjectLambdaAccessPointName
    def policy: ObjectLambdaPolicy
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getName: ZIO[Any, Nothing, ObjectLambdaAccessPointName] =
      ZIO.succeed(name)
    def getPolicy: ZIO[Any, Nothing, ObjectLambdaPolicy] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyForObjectLambdaRequest
  ) extends zio.aws.s3control.model.PutAccessPointPolicyForObjectLambdaRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val name: ObjectLambdaAccessPointName =
      zio.aws.s3control.model.primitives
        .ObjectLambdaAccessPointName(impl.name())
    override val policy: ObjectLambdaPolicy =
      zio.aws.s3control.model.primitives.ObjectLambdaPolicy(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyForObjectLambdaRequest
  ): zio.aws.s3control.model.PutAccessPointPolicyForObjectLambdaRequest.ReadOnly =
    new Wrapper(impl)
}
