package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{BucketName, AccountId}
import scala.jdk.CollectionConverters._
final case class PutBucketTaggingRequest(
    accountId: AccountId,
    bucket: BucketName,
    tagging: zio.aws.s3control.model.Tagging
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.PutBucketTaggingRequest = {
    import PutBucketTaggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.PutBucketTaggingRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .tagging(tagging.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.PutBucketTaggingRequest.ReadOnly =
    zio.aws.s3control.model.PutBucketTaggingRequest.wrap(buildAwsValue())
}
object PutBucketTaggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.PutBucketTaggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.PutBucketTaggingRequest =
      zio.aws.s3control.model
        .PutBucketTaggingRequest(accountId, bucket, tagging.asEditable)
    def accountId: AccountId
    def bucket: BucketName
    def tagging: zio.aws.s3control.model.Tagging.ReadOnly
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getTagging
        : ZIO[Any, Nothing, zio.aws.s3control.model.Tagging.ReadOnly] =
      ZIO.succeed(tagging)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.PutBucketTaggingRequest
  ) extends zio.aws.s3control.model.PutBucketTaggingRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val bucket: BucketName =
      zio.aws.s3control.model.primitives.BucketName(impl.bucket())
    override val tagging: zio.aws.s3control.model.Tagging.ReadOnly =
      zio.aws.s3control.model.Tagging.wrap(impl.tagging())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.PutBucketTaggingRequest
  ): zio.aws.s3control.model.PutBucketTaggingRequest.ReadOnly = new Wrapper(
    impl
  )
}
