package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.Minutes
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ReplicationTimeValue(
    minutes: Optional[Minutes] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ReplicationTimeValue = {
    import ReplicationTimeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ReplicationTimeValue
      .builder()
      .optionallyWith(minutes.map(value => Minutes.unwrap(value): Integer))(
        _.minutes
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.ReplicationTimeValue.ReadOnly =
    zio.aws.s3control.model.ReplicationTimeValue.wrap(buildAwsValue())
}
object ReplicationTimeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ReplicationTimeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ReplicationTimeValue =
      zio.aws.s3control.model.ReplicationTimeValue(minutes.map(value => value))
    def minutes: Optional[Minutes]
    def getMinutes: ZIO[Any, AwsError, Minutes] =
      AwsError.unwrapOptionField("minutes", minutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ReplicationTimeValue
  ) extends zio.aws.s3control.model.ReplicationTimeValue.ReadOnly {
    override val minutes: Optional[Minutes] = zio.aws.core.internal
      .optionalFromNullable(impl.minutes())
      .map(value => zio.aws.s3control.model.primitives.Minutes(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ReplicationTimeValue
  ): zio.aws.s3control.model.ReplicationTimeValue.ReadOnly = new Wrapper(impl)
}
