package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait S3GranteeTypeIdentifier {
  def unwrap
      : software.amazon.awssdk.services.s3control.model.S3GranteeTypeIdentifier
}
object S3GranteeTypeIdentifier {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.S3GranteeTypeIdentifier
  ): zio.aws.s3control.model.S3GranteeTypeIdentifier = value match {
    case software.amazon.awssdk.services.s3control.model.S3GranteeTypeIdentifier.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.S3GranteeTypeIdentifier.ID =>
      val r = id
      r
    case software.amazon.awssdk.services.s3control.model.S3GranteeTypeIdentifier.EMAIL_ADDRESS =>
      val r = emailAddress
      r
    case software.amazon.awssdk.services.s3control.model.S3GranteeTypeIdentifier.URI =>
      val r = uri
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.S3GranteeTypeIdentifier {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3GranteeTypeIdentifier =
      software.amazon.awssdk.services.s3control.model.S3GranteeTypeIdentifier.UNKNOWN_TO_SDK_VERSION
  }
  case object id extends zio.aws.s3control.model.S3GranteeTypeIdentifier {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3GranteeTypeIdentifier =
      software.amazon.awssdk.services.s3control.model.S3GranteeTypeIdentifier.ID
  }
  case object emailAddress
      extends zio.aws.s3control.model.S3GranteeTypeIdentifier {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3GranteeTypeIdentifier =
      software.amazon.awssdk.services.s3control.model.S3GranteeTypeIdentifier.EMAIL_ADDRESS
  }
  case object uri extends zio.aws.s3control.model.S3GranteeTypeIdentifier {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3GranteeTypeIdentifier =
      software.amazon.awssdk.services.s3control.model.S3GranteeTypeIdentifier.URI
  }
}
