package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{S3BucketArnString, AccountId}
import scala.jdk.CollectionConverters._
final case class S3JobManifestGenerator(
    expectedBucketOwner: Optional[AccountId] = Optional.Absent,
    sourceBucket: S3BucketArnString,
    manifestOutputLocation: Optional[
      zio.aws.s3control.model.S3ManifestOutputLocation
    ] = Optional.Absent,
    filter: Optional[zio.aws.s3control.model.JobManifestGeneratorFilter] =
      Optional.Absent,
    enableManifestOutput: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3JobManifestGenerator = {
    import S3JobManifestGenerator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3JobManifestGenerator
      .builder()
      .optionallyWith(
        expectedBucketOwner.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.expectedBucketOwner)
      .sourceBucket(S3BucketArnString.unwrap(sourceBucket): java.lang.String)
      .optionallyWith(
        manifestOutputLocation.map(value => value.buildAwsValue())
      )(_.manifestOutputLocation)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .enableManifestOutput(enableManifestOutput: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.S3JobManifestGenerator.ReadOnly =
    zio.aws.s3control.model.S3JobManifestGenerator.wrap(buildAwsValue())
}
object S3JobManifestGenerator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.S3JobManifestGenerator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3JobManifestGenerator =
      zio.aws.s3control.model.S3JobManifestGenerator(
        expectedBucketOwner.map(value => value),
        sourceBucket,
        manifestOutputLocation.map(value => value.asEditable),
        filter.map(value => value.asEditable),
        enableManifestOutput
      )
    def expectedBucketOwner: Optional[AccountId]
    def sourceBucket: S3BucketArnString
    def manifestOutputLocation
        : Optional[zio.aws.s3control.model.S3ManifestOutputLocation.ReadOnly]
    def filter
        : Optional[zio.aws.s3control.model.JobManifestGeneratorFilter.ReadOnly]
    def enableManifestOutput: Boolean
    def getExpectedBucketOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getSourceBucket: ZIO[Any, Nothing, S3BucketArnString] =
      ZIO.succeed(sourceBucket)
    def getManifestOutputLocation: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.S3ManifestOutputLocation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "manifestOutputLocation",
      manifestOutputLocation
    )
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.JobManifestGeneratorFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getEnableManifestOutput: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(enableManifestOutput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3JobManifestGenerator
  ) extends zio.aws.s3control.model.S3JobManifestGenerator.ReadOnly {
    override val expectedBucketOwner: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expectedBucketOwner())
        .map(value => zio.aws.s3control.model.primitives.AccountId(value))
    override val sourceBucket: S3BucketArnString =
      zio.aws.s3control.model.primitives.S3BucketArnString(impl.sourceBucket())
    override val manifestOutputLocation
        : Optional[zio.aws.s3control.model.S3ManifestOutputLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestOutputLocation())
        .map(value =>
          zio.aws.s3control.model.S3ManifestOutputLocation.wrap(value)
        )
    override val filter: Optional[
      zio.aws.s3control.model.JobManifestGeneratorFilter.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filter())
      .map(value =>
        zio.aws.s3control.model.JobManifestGeneratorFilter.wrap(value)
      )
    override val enableManifestOutput: Boolean =
      impl.enableManifestOutput(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3JobManifestGenerator
  ): zio.aws.s3control.model.S3JobManifestGenerator.ReadOnly = new Wrapper(impl)
}
