package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class S3SetObjectLegalHoldOperation(
    legalHold: zio.aws.s3control.model.S3ObjectLockLegalHold
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3SetObjectLegalHoldOperation = {
    import S3SetObjectLegalHoldOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3SetObjectLegalHoldOperation
      .builder()
      .legalHold(legalHold.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.S3SetObjectLegalHoldOperation.ReadOnly =
    zio.aws.s3control.model.S3SetObjectLegalHoldOperation.wrap(buildAwsValue())
}
object S3SetObjectLegalHoldOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.S3SetObjectLegalHoldOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3SetObjectLegalHoldOperation =
      zio.aws.s3control.model
        .S3SetObjectLegalHoldOperation(legalHold.asEditable)
    def legalHold: zio.aws.s3control.model.S3ObjectLockLegalHold.ReadOnly
    def getLegalHold: ZIO[
      Any,
      Nothing,
      zio.aws.s3control.model.S3ObjectLockLegalHold.ReadOnly
    ] = ZIO.succeed(legalHold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3SetObjectLegalHoldOperation
  ) extends zio.aws.s3control.model.S3SetObjectLegalHoldOperation.ReadOnly {
    override val legalHold
        : zio.aws.s3control.model.S3ObjectLockLegalHold.ReadOnly =
      zio.aws.s3control.model.S3ObjectLockLegalHold.wrap(impl.legalHold())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3SetObjectLegalHoldOperation
  ): zio.aws.s3control.model.S3SetObjectLegalHoldOperation.ReadOnly =
    new Wrapper(impl)
}
