package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3SetObjectTaggingOperation(
    tagSet: Optional[Iterable[zio.aws.s3control.model.S3Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3SetObjectTaggingOperation = {
    import S3SetObjectTaggingOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3SetObjectTaggingOperation
      .builder()
      .optionallyWith(
        tagSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSet)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.S3SetObjectTaggingOperation.ReadOnly =
    zio.aws.s3control.model.S3SetObjectTaggingOperation.wrap(buildAwsValue())
}
object S3SetObjectTaggingOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.S3SetObjectTaggingOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3SetObjectTaggingOperation =
      zio.aws.s3control.model.S3SetObjectTaggingOperation(
        tagSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tagSet: Optional[List[zio.aws.s3control.model.S3Tag.ReadOnly]]
    def getTagSet
        : ZIO[Any, AwsError, List[zio.aws.s3control.model.S3Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagSet", tagSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3SetObjectTaggingOperation
  ) extends zio.aws.s3control.model.S3SetObjectTaggingOperation.ReadOnly {
    override val tagSet
        : Optional[List[zio.aws.s3control.model.S3Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3control.model.S3Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3SetObjectTaggingOperation
  ): zio.aws.s3control.model.S3SetObjectTaggingOperation.ReadOnly = new Wrapper(
    impl
  )
}
