package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{TagValueString, TagKeyString}
import scala.jdk.CollectionConverters._
final case class StorageLensTag(key: TagKeyString, value: TagValueString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.StorageLensTag = {
    import StorageLensTag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.StorageLensTag
      .builder()
      .key(TagKeyString.unwrap(key): java.lang.String)
      .value(TagValueString.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.StorageLensTag.ReadOnly =
    zio.aws.s3control.model.StorageLensTag.wrap(buildAwsValue())
}
object StorageLensTag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.StorageLensTag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.StorageLensTag =
      zio.aws.s3control.model.StorageLensTag(key, value)
    def key: TagKeyString
    def value: TagValueString
    def getKey: ZIO[Any, Nothing, TagKeyString] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagValueString] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.StorageLensTag
  ) extends zio.aws.s3control.model.StorageLensTag.ReadOnly {
    override val key: TagKeyString =
      zio.aws.s3control.model.primitives.TagKeyString(impl.key())
    override val value: TagValueString =
      zio.aws.s3control.model.primitives.TagValueString(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.StorageLensTag
  ): zio.aws.s3control.model.StorageLensTag.ReadOnly = new Wrapper(impl)
}
