package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{BucketName, AccountId}
import scala.jdk.CollectionConverters._
final case class DeleteBucketLifecycleConfigurationRequest(
    accountId: AccountId,
    bucket: BucketName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.DeleteBucketLifecycleConfigurationRequest = {
    import DeleteBucketLifecycleConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.DeleteBucketLifecycleConfigurationRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.DeleteBucketLifecycleConfigurationRequest.ReadOnly =
    zio.aws.s3control.model.DeleteBucketLifecycleConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteBucketLifecycleConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.DeleteBucketLifecycleConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.DeleteBucketLifecycleConfigurationRequest =
      zio.aws.s3control.model
        .DeleteBucketLifecycleConfigurationRequest(accountId, bucket)
    def accountId: AccountId
    def bucket: BucketName
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.DeleteBucketLifecycleConfigurationRequest
  ) extends zio.aws.s3control.model.DeleteBucketLifecycleConfigurationRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val bucket: BucketName =
      zio.aws.s3control.model.primitives.BucketName(impl.bucket())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.DeleteBucketLifecycleConfigurationRequest
  ): zio.aws.s3control.model.DeleteBucketLifecycleConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
