package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetJobTaggingResponse(
    tags: Optional[Iterable[zio.aws.s3control.model.S3Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetJobTaggingResponse = {
    import GetJobTaggingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetJobTaggingResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.GetJobTaggingResponse.ReadOnly =
    zio.aws.s3control.model.GetJobTaggingResponse.wrap(buildAwsValue())
}
object GetJobTaggingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetJobTaggingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GetJobTaggingResponse =
      zio.aws.s3control.model.GetJobTaggingResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tags: Optional[List[zio.aws.s3control.model.S3Tag.ReadOnly]]
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.s3control.model.S3Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetJobTaggingResponse
  ) extends zio.aws.s3control.model.GetJobTaggingResponse.ReadOnly {
    override val tags: Optional[List[zio.aws.s3control.model.S3Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.s3control.model.S3Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetJobTaggingResponse
  ): zio.aws.s3control.model.GetJobTaggingResponse.ReadOnly = new Wrapper(impl)
}
