package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{
  ObjectLambdaAccessPointArn,
  ObjectLambdaAccessPointName
}
import scala.jdk.CollectionConverters._
final case class ObjectLambdaAccessPoint(
    name: ObjectLambdaAccessPointName,
    objectLambdaAccessPointArn: Optional[ObjectLambdaAccessPointArn] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPoint = {
    import ObjectLambdaAccessPoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPoint
      .builder()
      .name(ObjectLambdaAccessPointName.unwrap(name): java.lang.String)
      .optionallyWith(
        objectLambdaAccessPointArn.map(value =>
          ObjectLambdaAccessPointArn.unwrap(value): java.lang.String
        )
      )(_.objectLambdaAccessPointArn)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.ObjectLambdaAccessPoint.ReadOnly =
    zio.aws.s3control.model.ObjectLambdaAccessPoint.wrap(buildAwsValue())
}
object ObjectLambdaAccessPoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ObjectLambdaAccessPoint =
      zio.aws.s3control.model.ObjectLambdaAccessPoint(
        name,
        objectLambdaAccessPointArn.map(value => value)
      )
    def name: ObjectLambdaAccessPointName
    def objectLambdaAccessPointArn: Optional[ObjectLambdaAccessPointArn]
    def getName: ZIO[Any, Nothing, ObjectLambdaAccessPointName] =
      ZIO.succeed(name)
    def getObjectLambdaAccessPointArn
        : ZIO[Any, AwsError, ObjectLambdaAccessPointArn] =
      AwsError.unwrapOptionField(
        "objectLambdaAccessPointArn",
        objectLambdaAccessPointArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPoint
  ) extends zio.aws.s3control.model.ObjectLambdaAccessPoint.ReadOnly {
    override val name: ObjectLambdaAccessPointName =
      zio.aws.s3control.model.primitives
        .ObjectLambdaAccessPointName(impl.name())
    override val objectLambdaAccessPointArn
        : Optional[ObjectLambdaAccessPointArn] = zio.aws.core.internal
      .optionalFromNullable(impl.objectLambdaAccessPointArn())
      .map(value =>
        zio.aws.s3control.model.primitives.ObjectLambdaAccessPointArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ObjectLambdaAccessPoint
  ): zio.aws.s3control.model.ObjectLambdaAccessPoint.ReadOnly = new Wrapper(
    impl
  )
}
