package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{Policy, AccessPointName, AccountId}
import scala.jdk.CollectionConverters._
final case class PutAccessPointPolicyRequest(
    accountId: AccountId,
    name: AccessPointName,
    policy: Policy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyRequest = {
    import PutAccessPointPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .name(AccessPointName.unwrap(name): java.lang.String)
      .policy(Policy.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.PutAccessPointPolicyRequest.ReadOnly =
    zio.aws.s3control.model.PutAccessPointPolicyRequest.wrap(buildAwsValue())
}
object PutAccessPointPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.PutAccessPointPolicyRequest =
      zio.aws.s3control.model
        .PutAccessPointPolicyRequest(accountId, name, policy)
    def accountId: AccountId
    def name: AccessPointName
    def policy: Policy
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getName: ZIO[Any, Nothing, AccessPointName] = ZIO.succeed(name)
    def getPolicy: ZIO[Any, Nothing, Policy] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyRequest
  ) extends zio.aws.s3control.model.PutAccessPointPolicyRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val name: AccessPointName =
      zio.aws.s3control.model.primitives.AccessPointName(impl.name())
    override val policy: Policy =
      zio.aws.s3control.model.primitives.Policy(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.PutAccessPointPolicyRequest
  ): zio.aws.s3control.model.PutAccessPointPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
