package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{
  MultiRegionAccessPointClientToken,
  AccountId
}
import scala.jdk.CollectionConverters._
final case class PutMultiRegionAccessPointPolicyRequest(
    accountId: AccountId,
    clientToken: MultiRegionAccessPointClientToken,
    details: zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyRequest = {
    import PutMultiRegionAccessPointPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .clientToken(
        MultiRegionAccessPointClientToken.unwrap(clientToken): java.lang.String
      )
      .details(details.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.PutMultiRegionAccessPointPolicyRequest.ReadOnly =
    zio.aws.s3control.model.PutMultiRegionAccessPointPolicyRequest
      .wrap(buildAwsValue())
}
object PutMultiRegionAccessPointPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.PutMultiRegionAccessPointPolicyRequest =
      zio.aws.s3control.model.PutMultiRegionAccessPointPolicyRequest(
        accountId,
        clientToken,
        details.asEditable
      )
    def accountId: AccountId
    def clientToken: MultiRegionAccessPointClientToken
    def details
        : zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput.ReadOnly
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getClientToken: ZIO[Any, Nothing, MultiRegionAccessPointClientToken] =
      ZIO.succeed(clientToken)
    def getDetails: ZIO[
      Any,
      Nothing,
      zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput.ReadOnly
    ] = ZIO.succeed(details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyRequest
  ) extends zio.aws.s3control.model.PutMultiRegionAccessPointPolicyRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val clientToken: MultiRegionAccessPointClientToken =
      zio.aws.s3control.model.primitives
        .MultiRegionAccessPointClientToken(impl.clientToken())
    override val details
        : zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput.ReadOnly =
      zio.aws.s3control.model.PutMultiRegionAccessPointPolicyInput
        .wrap(impl.details())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyRequest
  ): zio.aws.s3control.model.PutMultiRegionAccessPointPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
