package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String
import scala.jdk.CollectionConverters._
final case class S3Grantee(
    typeIdentifier: Optional[zio.aws.s3control.model.S3GranteeTypeIdentifier] =
      Optional.Absent,
    identifier: Optional[NonEmptyMaxLength1024String] = Optional.Absent,
    displayName: Optional[NonEmptyMaxLength1024String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3Grantee = {
    import S3Grantee.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3Grantee
      .builder()
      .optionallyWith(typeIdentifier.map(value => value.unwrap))(
        _.typeIdentifier
      )
      .optionallyWith(
        identifier.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.identifier)
      .optionallyWith(
        displayName.map(value =>
          NonEmptyMaxLength1024String.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.S3Grantee.ReadOnly =
    zio.aws.s3control.model.S3Grantee.wrap(buildAwsValue())
}
object S3Grantee {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.S3Grantee
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3Grantee =
      zio.aws.s3control.model.S3Grantee(
        typeIdentifier.map(value => value),
        identifier.map(value => value),
        displayName.map(value => value)
      )
    def typeIdentifier
        : Optional[zio.aws.s3control.model.S3GranteeTypeIdentifier]
    def identifier: Optional[NonEmptyMaxLength1024String]
    def displayName: Optional[NonEmptyMaxLength1024String]
    def getTypeIdentifier
        : ZIO[Any, AwsError, zio.aws.s3control.model.S3GranteeTypeIdentifier] =
      AwsError.unwrapOptionField("typeIdentifier", typeIdentifier)
    def getIdentifier: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("identifier", identifier)
    def getDisplayName: ZIO[Any, AwsError, NonEmptyMaxLength1024String] =
      AwsError.unwrapOptionField("displayName", displayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3Grantee
  ) extends zio.aws.s3control.model.S3Grantee.ReadOnly {
    override val typeIdentifier
        : Optional[zio.aws.s3control.model.S3GranteeTypeIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.typeIdentifier())
        .map(value =>
          zio.aws.s3control.model.S3GranteeTypeIdentifier.wrap(value)
        )
    override val identifier: Optional[NonEmptyMaxLength1024String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identifier())
        .map(value =>
          zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
        )
    override val displayName: Optional[NonEmptyMaxLength1024String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.s3control.model.primitives.NonEmptyMaxLength1024String(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3Grantee
  ): zio.aws.s3control.model.S3Grantee.ReadOnly = new Wrapper(impl)
}
