package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait S3SSEAlgorithm {
  def unwrap: software.amazon.awssdk.services.s3control.model.S3SSEAlgorithm
}
object S3SSEAlgorithm {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.S3SSEAlgorithm
  ): zio.aws.s3control.model.S3SSEAlgorithm = value match {
    case software.amazon.awssdk.services.s3control.model.S3SSEAlgorithm.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.S3SSEAlgorithm.AES256 =>
      val r = AES256
      r
    case software.amazon.awssdk.services.s3control.model.S3SSEAlgorithm.KMS =>
      val r = KMS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.S3SSEAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3SSEAlgorithm =
      software.amazon.awssdk.services.s3control.model.S3SSEAlgorithm.UNKNOWN_TO_SDK_VERSION
  }
  case object AES256 extends zio.aws.s3control.model.S3SSEAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3SSEAlgorithm =
      software.amazon.awssdk.services.s3control.model.S3SSEAlgorithm.AES256
  }
  case object KMS extends zio.aws.s3control.model.S3SSEAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3SSEAlgorithm =
      software.amazon.awssdk.services.s3control.model.S3SSEAlgorithm.KMS
  }
}
