package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3SetObjectRetentionOperation(
    bypassGovernanceRetention: Optional[Boolean] = Optional.Absent,
    retention: zio.aws.s3control.model.S3Retention
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.S3SetObjectRetentionOperation = {
    import S3SetObjectRetentionOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3SetObjectRetentionOperation
      .builder()
      .optionallyWith(
        bypassGovernanceRetention.map(value => value: java.lang.Boolean)
      )(_.bypassGovernanceRetention)
      .retention(retention.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.S3SetObjectRetentionOperation.ReadOnly =
    zio.aws.s3control.model.S3SetObjectRetentionOperation.wrap(buildAwsValue())
}
object S3SetObjectRetentionOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.S3SetObjectRetentionOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3SetObjectRetentionOperation =
      zio.aws.s3control.model.S3SetObjectRetentionOperation(
        bypassGovernanceRetention.map(value => value),
        retention.asEditable
      )
    def bypassGovernanceRetention: Optional[Boolean]
    def retention: zio.aws.s3control.model.S3Retention.ReadOnly
    def getBypassGovernanceRetention: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("bypassGovernanceRetention", bypassGovernanceRetention)
    def getRetention
        : ZIO[Any, Nothing, zio.aws.s3control.model.S3Retention.ReadOnly] =
      ZIO.succeed(retention)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3SetObjectRetentionOperation
  ) extends zio.aws.s3control.model.S3SetObjectRetentionOperation.ReadOnly {
    override val bypassGovernanceRetention: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bypassGovernanceRetention())
        .map(value => value: Boolean)
    override val retention: zio.aws.s3control.model.S3Retention.ReadOnly =
      zio.aws.s3control.model.S3Retention.wrap(impl.retention())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3SetObjectRetentionOperation
  ): zio.aws.s3control.model.S3SetObjectRetentionOperation.ReadOnly =
    new Wrapper(impl)
}
