package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{TagValueString, TagKeyString}
import scala.jdk.CollectionConverters._
final case class S3Tag(key: TagKeyString, value: TagValueString) {
  def buildAwsValue(): software.amazon.awssdk.services.s3control.model.S3Tag = {
    import S3Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.S3Tag
      .builder()
      .key(TagKeyString.unwrap(key): java.lang.String)
      .value(TagValueString.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.S3Tag.ReadOnly =
    zio.aws.s3control.model.S3Tag.wrap(buildAwsValue())
}
object S3Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3control.model.S3Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.S3Tag =
      zio.aws.s3control.model.S3Tag(key, value)
    def key: TagKeyString
    def value: TagValueString
    def getKey: ZIO[Any, Nothing, TagKeyString] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagValueString] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.S3Tag
  ) extends zio.aws.s3control.model.S3Tag.ReadOnly {
    override val key: TagKeyString =
      zio.aws.s3control.model.primitives.TagKeyString(impl.key())
    override val value: TagValueString =
      zio.aws.s3control.model.primitives.TagValueString(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.S3Tag
  ): zio.aws.s3control.model.S3Tag.ReadOnly = new Wrapper(impl)
}
