package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.SSEKMSKeyId
import scala.jdk.CollectionConverters._
final case class SSEKMS(keyId: SSEKMSKeyId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.SSEKMS = {
    import SSEKMS.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.SSEKMS
      .builder()
      .keyId(SSEKMSKeyId.unwrap(keyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.SSEKMS.ReadOnly =
    zio.aws.s3control.model.SSEKMS.wrap(buildAwsValue())
}
object SSEKMS {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3control.model.SSEKMS] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.SSEKMS =
      zio.aws.s3control.model.SSEKMS(keyId)
    def keyId: SSEKMSKeyId
    def getKeyId: ZIO[Any, Nothing, SSEKMSKeyId] = ZIO.succeed(keyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.SSEKMS
  ) extends zio.aws.s3control.model.SSEKMS.ReadOnly {
    override val keyId: SSEKMSKeyId =
      zio.aws.s3control.model.primitives.SSEKMSKeyId(impl.keyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.SSEKMS
  ): zio.aws.s3control.model.SSEKMS.ReadOnly = new Wrapper(impl)
}
