package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateBucketConfiguration(
    locationConstraint: Optional[
      zio.aws.s3control.model.BucketLocationConstraint
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.CreateBucketConfiguration = {
    import CreateBucketConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.CreateBucketConfiguration
      .builder()
      .optionallyWith(locationConstraint.map(value => value.unwrap))(
        _.locationConstraint
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.CreateBucketConfiguration.ReadOnly =
    zio.aws.s3control.model.CreateBucketConfiguration.wrap(buildAwsValue())
}
object CreateBucketConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.CreateBucketConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.CreateBucketConfiguration =
      zio.aws.s3control.model
        .CreateBucketConfiguration(locationConstraint.map(value => value))
    def locationConstraint
        : Optional[zio.aws.s3control.model.BucketLocationConstraint]
    def getLocationConstraint
        : ZIO[Any, AwsError, zio.aws.s3control.model.BucketLocationConstraint] =
      AwsError.unwrapOptionField("locationConstraint", locationConstraint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.CreateBucketConfiguration
  ) extends zio.aws.s3control.model.CreateBucketConfiguration.ReadOnly {
    override val locationConstraint
        : Optional[zio.aws.s3control.model.BucketLocationConstraint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locationConstraint())
        .map(value =>
          zio.aws.s3control.model.BucketLocationConstraint.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.CreateBucketConfiguration
  ): zio.aws.s3control.model.CreateBucketConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
