package zio.aws.s3control.model
import zio.aws.s3control.model.primitives.{
  CreationDate,
  ObjectLambdaAccessPointName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetAccessPointForObjectLambdaResponse(
    name: Optional[ObjectLambdaAccessPointName] = Optional.Absent,
    publicAccessBlockConfiguration: Optional[
      zio.aws.s3control.model.PublicAccessBlockConfiguration
    ] = Optional.Absent,
    creationDate: Optional[CreationDate] = Optional.Absent,
    alias: Optional[zio.aws.s3control.model.ObjectLambdaAccessPointAlias] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaResponse = {
    import GetAccessPointForObjectLambdaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaResponse
      .builder()
      .optionallyWith(
        name.map(value =>
          ObjectLambdaAccessPointName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        publicAccessBlockConfiguration.map(value => value.buildAwsValue())
      )(_.publicAccessBlockConfiguration)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(alias.map(value => value.buildAwsValue()))(_.alias)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetAccessPointForObjectLambdaResponse.ReadOnly =
    zio.aws.s3control.model.GetAccessPointForObjectLambdaResponse
      .wrap(buildAwsValue())
}
object GetAccessPointForObjectLambdaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.GetAccessPointForObjectLambdaResponse =
      zio.aws.s3control.model.GetAccessPointForObjectLambdaResponse(
        name.map(value => value),
        publicAccessBlockConfiguration.map(value => value.asEditable),
        creationDate.map(value => value),
        alias.map(value => value.asEditable)
      )
    def name: Optional[ObjectLambdaAccessPointName]
    def publicAccessBlockConfiguration: Optional[
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ]
    def creationDate: Optional[CreationDate]
    def alias: Optional[
      zio.aws.s3control.model.ObjectLambdaAccessPointAlias.ReadOnly
    ]
    def getName: ZIO[Any, AwsError, ObjectLambdaAccessPointName] =
      AwsError.unwrapOptionField("name", name)
    def getPublicAccessBlockConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "publicAccessBlockConfiguration",
      publicAccessBlockConfiguration
    )
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getAlias: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.ObjectLambdaAccessPointAlias.ReadOnly
    ] = AwsError.unwrapOptionField("alias", alias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaResponse
  ) extends zio.aws.s3control.model.GetAccessPointForObjectLambdaResponse.ReadOnly {
    override val name: Optional[ObjectLambdaAccessPointName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.s3control.model.primitives.ObjectLambdaAccessPointName(value)
        )
    override val publicAccessBlockConfiguration: Optional[
      zio.aws.s3control.model.PublicAccessBlockConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.publicAccessBlockConfiguration())
      .map(value =>
        zio.aws.s3control.model.PublicAccessBlockConfiguration.wrap(value)
      )
    override val creationDate: Optional[CreationDate] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.s3control.model.primitives.CreationDate(value))
    override val alias: Optional[
      zio.aws.s3control.model.ObjectLambdaAccessPointAlias.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.alias())
      .map(value =>
        zio.aws.s3control.model.ObjectLambdaAccessPointAlias.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointForObjectLambdaResponse
  ): zio.aws.s3control.model.GetAccessPointForObjectLambdaResponse.ReadOnly =
    new Wrapper(impl)
}
