package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{
  ObjectLambdaAccessPointName,
  AccountId
}
import scala.jdk.CollectionConverters._
final case class GetAccessPointPolicyForObjectLambdaRequest(
    accountId: AccountId,
    name: ObjectLambdaAccessPointName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaRequest = {
    import GetAccessPointPolicyForObjectLambdaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .name(ObjectLambdaAccessPointName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaRequest.ReadOnly =
    zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaRequest
      .wrap(buildAwsValue())
}
object GetAccessPointPolicyForObjectLambdaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaRequest =
      zio.aws.s3control.model
        .GetAccessPointPolicyForObjectLambdaRequest(accountId, name)
    def accountId: AccountId
    def name: ObjectLambdaAccessPointName
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getName: ZIO[Any, Nothing, ObjectLambdaAccessPointName] =
      ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaRequest
  ) extends zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val name: ObjectLambdaAccessPointName =
      zio.aws.s3control.model.primitives
        .ObjectLambdaAccessPointName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetAccessPointPolicyForObjectLambdaRequest
  ): zio.aws.s3control.model.GetAccessPointPolicyForObjectLambdaRequest.ReadOnly =
    new Wrapper(impl)
}
