package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBucketVersioningResponse(
    status: Optional[zio.aws.s3control.model.BucketVersioningStatus] =
      Optional.Absent,
    mfaDelete: Optional[zio.aws.s3control.model.MFADeleteStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.GetBucketVersioningResponse = {
    import GetBucketVersioningResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.GetBucketVersioningResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(mfaDelete.map(value => value.unwrap))(_.mfaDelete)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.GetBucketVersioningResponse.ReadOnly =
    zio.aws.s3control.model.GetBucketVersioningResponse.wrap(buildAwsValue())
}
object GetBucketVersioningResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.GetBucketVersioningResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.GetBucketVersioningResponse =
      zio.aws.s3control.model.GetBucketVersioningResponse(
        status.map(value => value),
        mfaDelete.map(value => value)
      )
    def status: Optional[zio.aws.s3control.model.BucketVersioningStatus]
    def mfaDelete: Optional[zio.aws.s3control.model.MFADeleteStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.s3control.model.BucketVersioningStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMfaDelete
        : ZIO[Any, AwsError, zio.aws.s3control.model.MFADeleteStatus] =
      AwsError.unwrapOptionField("mfaDelete", mfaDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.GetBucketVersioningResponse
  ) extends zio.aws.s3control.model.GetBucketVersioningResponse.ReadOnly {
    override val status
        : Optional[zio.aws.s3control.model.BucketVersioningStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.s3control.model.BucketVersioningStatus.wrap(value)
        )
    override val mfaDelete: Optional[zio.aws.s3control.model.MFADeleteStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mfaDelete())
        .map(value => zio.aws.s3control.model.MFADeleteStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.GetBucketVersioningResponse
  ): zio.aws.s3control.model.GetBucketVersioningResponse.ReadOnly = new Wrapper(
    impl
  )
}
