package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class JobManifest(
    spec: zio.aws.s3control.model.JobManifestSpec,
    location: zio.aws.s3control.model.JobManifestLocation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.JobManifest = {
    import JobManifest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.JobManifest
      .builder()
      .spec(spec.buildAwsValue())
      .location(location.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.JobManifest.ReadOnly =
    zio.aws.s3control.model.JobManifest.wrap(buildAwsValue())
}
object JobManifest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.JobManifest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.JobManifest =
      zio.aws.s3control.model.JobManifest(spec.asEditable, location.asEditable)
    def spec: zio.aws.s3control.model.JobManifestSpec.ReadOnly
    def location: zio.aws.s3control.model.JobManifestLocation.ReadOnly
    def getSpec
        : ZIO[Any, Nothing, zio.aws.s3control.model.JobManifestSpec.ReadOnly] =
      ZIO.succeed(spec)
    def getLocation: ZIO[
      Any,
      Nothing,
      zio.aws.s3control.model.JobManifestLocation.ReadOnly
    ] = ZIO.succeed(location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.JobManifest
  ) extends zio.aws.s3control.model.JobManifest.ReadOnly {
    override val spec: zio.aws.s3control.model.JobManifestSpec.ReadOnly =
      zio.aws.s3control.model.JobManifestSpec.wrap(impl.spec())
    override val location
        : zio.aws.s3control.model.JobManifestLocation.ReadOnly =
      zio.aws.s3control.model.JobManifestLocation.wrap(impl.location())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.JobManifest
  ): zio.aws.s3control.model.JobManifest.ReadOnly = new Wrapper(impl)
}
