package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{ContinuationToken, AccountId}
import scala.jdk.CollectionConverters._
final case class ListStorageLensConfigurationsRequest(
    accountId: AccountId,
    nextToken: Optional[ContinuationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsRequest = {
    import ListStorageLensConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .optionallyWith(
        nextToken.map(value =>
          ContinuationToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.ListStorageLensConfigurationsRequest.ReadOnly =
    zio.aws.s3control.model.ListStorageLensConfigurationsRequest
      .wrap(buildAwsValue())
}
object ListStorageLensConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.ListStorageLensConfigurationsRequest =
      zio.aws.s3control.model.ListStorageLensConfigurationsRequest(
        accountId,
        nextToken.map(value => value)
      )
    def accountId: AccountId
    def nextToken: Optional[ContinuationToken]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getNextToken: ZIO[Any, AwsError, ContinuationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsRequest
  ) extends zio.aws.s3control.model.ListStorageLensConfigurationsRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val nextToken: Optional[ContinuationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.s3control.model.primitives.ContinuationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ListStorageLensConfigurationsRequest
  ): zio.aws.s3control.model.ListStorageLensConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
