package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{
  Policy,
  ConfirmRemoveSelfBucketAccess,
  BucketName,
  AccountId
}
import scala.jdk.CollectionConverters._
final case class PutBucketPolicyRequest(
    accountId: AccountId,
    bucket: BucketName,
    confirmRemoveSelfBucketAccess: Optional[ConfirmRemoveSelfBucketAccess] =
      Optional.Absent,
    policy: Policy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.PutBucketPolicyRequest = {
    import PutBucketPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.PutBucketPolicyRequest
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        confirmRemoveSelfBucketAccess.map(value =>
          ConfirmRemoveSelfBucketAccess.unwrap(value): java.lang.Boolean
        )
      )(_.confirmRemoveSelfBucketAccess)
      .policy(Policy.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.PutBucketPolicyRequest.ReadOnly =
    zio.aws.s3control.model.PutBucketPolicyRequest.wrap(buildAwsValue())
}
object PutBucketPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.PutBucketPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.PutBucketPolicyRequest =
      zio.aws.s3control.model.PutBucketPolicyRequest(
        accountId,
        bucket,
        confirmRemoveSelfBucketAccess.map(value => value),
        policy
      )
    def accountId: AccountId
    def bucket: BucketName
    def confirmRemoveSelfBucketAccess: Optional[ConfirmRemoveSelfBucketAccess]
    def policy: Policy
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getConfirmRemoveSelfBucketAccess
        : ZIO[Any, AwsError, ConfirmRemoveSelfBucketAccess] =
      AwsError.unwrapOptionField(
        "confirmRemoveSelfBucketAccess",
        confirmRemoveSelfBucketAccess
      )
    def getPolicy: ZIO[Any, Nothing, Policy] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.PutBucketPolicyRequest
  ) extends zio.aws.s3control.model.PutBucketPolicyRequest.ReadOnly {
    override val accountId: AccountId =
      zio.aws.s3control.model.primitives.AccountId(impl.accountId())
    override val bucket: BucketName =
      zio.aws.s3control.model.primitives.BucketName(impl.bucket())
    override val confirmRemoveSelfBucketAccess
        : Optional[ConfirmRemoveSelfBucketAccess] = zio.aws.core.internal
      .optionalFromNullable(impl.confirmRemoveSelfBucketAccess())
      .map(value =>
        zio.aws.s3control.model.primitives.ConfirmRemoveSelfBucketAccess(value)
      )
    override val policy: Policy =
      zio.aws.s3control.model.primitives.Policy(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.PutBucketPolicyRequest
  ): zio.aws.s3control.model.PutBucketPolicyRequest.ReadOnly = new Wrapper(impl)
}
