package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.AsyncRequestTokenARN
import scala.jdk.CollectionConverters._
final case class PutMultiRegionAccessPointPolicyResponse(
    requestTokenARN: Optional[AsyncRequestTokenARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyResponse = {
    import PutMultiRegionAccessPointPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyResponse
      .builder()
      .optionallyWith(
        requestTokenARN.map(value =>
          AsyncRequestTokenARN.unwrap(value): java.lang.String
        )
      )(_.requestTokenARN)
      .build()
  }
  def asReadOnly
      : zio.aws.s3control.model.PutMultiRegionAccessPointPolicyResponse.ReadOnly =
    zio.aws.s3control.model.PutMultiRegionAccessPointPolicyResponse
      .wrap(buildAwsValue())
}
object PutMultiRegionAccessPointPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.s3control.model.PutMultiRegionAccessPointPolicyResponse =
      zio.aws.s3control.model.PutMultiRegionAccessPointPolicyResponse(
        requestTokenARN.map(value => value)
      )
    def requestTokenARN: Optional[AsyncRequestTokenARN]
    def getRequestTokenARN: ZIO[Any, AwsError, AsyncRequestTokenARN] =
      AwsError.unwrapOptionField("requestTokenARN", requestTokenARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyResponse
  ) extends zio.aws.s3control.model.PutMultiRegionAccessPointPolicyResponse.ReadOnly {
    override val requestTokenARN: Optional[AsyncRequestTokenARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestTokenARN())
        .map(value =>
          zio.aws.s3control.model.primitives.AsyncRequestTokenARN(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.PutMultiRegionAccessPointPolicyResponse
  ): zio.aws.s3control.model.PutMultiRegionAccessPointPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
