package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{AccountId, BucketName}
import scala.jdk.CollectionConverters._
final case class Region(
    bucket: BucketName,
    bucketAccountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.Region = {
    import Region.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.Region
      .builder()
      .bucket(BucketName.unwrap(bucket): java.lang.String)
      .optionallyWith(
        bucketAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.bucketAccountId)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.Region.ReadOnly =
    zio.aws.s3control.model.Region.wrap(buildAwsValue())
}
object Region {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3control.model.Region] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.Region = zio.aws.s3control.model
      .Region(bucket, bucketAccountId.map(value => value))
    def bucket: BucketName
    def bucketAccountId: Optional[AccountId]
    def getBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucket)
    def getBucketAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("bucketAccountId", bucketAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.Region
  ) extends zio.aws.s3control.model.Region.ReadOnly {
    override val bucket: BucketName =
      zio.aws.s3control.model.primitives.BucketName(impl.bucket())
    override val bucketAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketAccountId())
      .map(value => zio.aws.s3control.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.Region
  ): zio.aws.s3control.model.Region.ReadOnly = new Wrapper(impl)
}
