package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.Role
import scala.jdk.CollectionConverters._
final case class ReplicationConfiguration(
    role: Role,
    rules: Iterable[zio.aws.s3control.model.ReplicationRule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.ReplicationConfiguration = {
    import ReplicationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.ReplicationConfiguration
      .builder()
      .role(Role.unwrap(role): java.lang.String)
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.ReplicationConfiguration.ReadOnly =
    zio.aws.s3control.model.ReplicationConfiguration.wrap(buildAwsValue())
}
object ReplicationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.ReplicationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.ReplicationConfiguration =
      zio.aws.s3control.model.ReplicationConfiguration(
        role,
        rules.map { item =>
          item.asEditable
        }
      )
    def role: Role
    def rules: List[zio.aws.s3control.model.ReplicationRule.ReadOnly]
    def getRole: ZIO[Any, Nothing, Role] = ZIO.succeed(role)
    def getRules: ZIO[Any, Nothing, List[
      zio.aws.s3control.model.ReplicationRule.ReadOnly
    ]] = ZIO.succeed(rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.ReplicationConfiguration
  ) extends zio.aws.s3control.model.ReplicationConfiguration.ReadOnly {
    override val role: Role =
      zio.aws.s3control.model.primitives.Role(impl.role())
    override val rules: List[zio.aws.s3control.model.ReplicationRule.ReadOnly] =
      impl
        .rules()
        .asScala
        .map { item =>
          zio.aws.s3control.model.ReplicationRule.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.ReplicationConfiguration
  ): zio.aws.s3control.model.ReplicationConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
