package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait S3GlacierJobTier {
  def unwrap: software.amazon.awssdk.services.s3control.model.S3GlacierJobTier
}
object S3GlacierJobTier {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.S3GlacierJobTier
  ): zio.aws.s3control.model.S3GlacierJobTier = value match {
    case software.amazon.awssdk.services.s3control.model.S3GlacierJobTier.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.S3GlacierJobTier.BULK =>
      val r = BULK
      r
    case software.amazon.awssdk.services.s3control.model.S3GlacierJobTier.STANDARD =>
      val r = STANDARD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.S3GlacierJobTier {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3GlacierJobTier =
      software.amazon.awssdk.services.s3control.model.S3GlacierJobTier.UNKNOWN_TO_SDK_VERSION
  }
  case object BULK extends zio.aws.s3control.model.S3GlacierJobTier {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3GlacierJobTier =
      software.amazon.awssdk.services.s3control.model.S3GlacierJobTier.BULK
  }
  case object STANDARD extends zio.aws.s3control.model.S3GlacierJobTier {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3GlacierJobTier =
      software.amazon.awssdk.services.s3control.model.S3GlacierJobTier.STANDARD
  }
}
