package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait S3ObjectLockLegalHoldStatus {
  def unwrap: software.amazon.awssdk.services.s3control.model.S3ObjectLockLegalHoldStatus
}
object S3ObjectLockLegalHoldStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.S3ObjectLockLegalHoldStatus
  ): zio.aws.s3control.model.S3ObjectLockLegalHoldStatus = value match {
    case software.amazon.awssdk.services.s3control.model.S3ObjectLockLegalHoldStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.S3ObjectLockLegalHoldStatus.OFF =>
      val r = OFF
      r
    case software.amazon.awssdk.services.s3control.model.S3ObjectLockLegalHoldStatus.ON =>
      val r = ON
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.S3ObjectLockLegalHoldStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3ObjectLockLegalHoldStatus =
      software.amazon.awssdk.services.s3control.model.S3ObjectLockLegalHoldStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object OFF extends zio.aws.s3control.model.S3ObjectLockLegalHoldStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3ObjectLockLegalHoldStatus =
      software.amazon.awssdk.services.s3control.model.S3ObjectLockLegalHoldStatus.OFF
  }
  case object ON extends zio.aws.s3control.model.S3ObjectLockLegalHoldStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3ObjectLockLegalHoldStatus =
      software.amazon.awssdk.services.s3control.model.S3ObjectLockLegalHoldStatus.ON
  }
}
