package zio.aws.s3control.model
import scala.jdk.CollectionConverters._
sealed trait S3Permission {
  def unwrap: software.amazon.awssdk.services.s3control.model.S3Permission
}
object S3Permission {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.S3Permission
  ): zio.aws.s3control.model.S3Permission = value match {
    case software.amazon.awssdk.services.s3control.model.S3Permission.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.S3Permission.FULL_CONTROL =>
      val r = FULL_CONTROL
      r
    case software.amazon.awssdk.services.s3control.model.S3Permission.READ =>
      val r = READ
      r
    case software.amazon.awssdk.services.s3control.model.S3Permission.WRITE =>
      val r = WRITE
      r
    case software.amazon.awssdk.services.s3control.model.S3Permission.READ_ACP =>
      val r = READ_ACP
      r
    case software.amazon.awssdk.services.s3control.model.S3Permission.WRITE_ACP =>
      val r = WRITE_ACP
      r
  }
  case object unknownToSdkVersion extends zio.aws.s3control.model.S3Permission {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3Permission =
      software.amazon.awssdk.services.s3control.model.S3Permission.UNKNOWN_TO_SDK_VERSION
  }
  case object FULL_CONTROL extends zio.aws.s3control.model.S3Permission {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3Permission =
      software.amazon.awssdk.services.s3control.model.S3Permission.FULL_CONTROL
  }
  case object READ extends zio.aws.s3control.model.S3Permission {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3Permission =
      software.amazon.awssdk.services.s3control.model.S3Permission.READ
  }
  case object WRITE extends zio.aws.s3control.model.S3Permission {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3Permission =
      software.amazon.awssdk.services.s3control.model.S3Permission.WRITE
  }
  case object READ_ACP extends zio.aws.s3control.model.S3Permission {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3Permission =
      software.amazon.awssdk.services.s3control.model.S3Permission.READ_ACP
  }
  case object WRITE_ACP extends zio.aws.s3control.model.S3Permission {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.S3Permission =
      software.amazon.awssdk.services.s3control.model.S3Permission.WRITE_ACP
  }
}
