package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.s3control.model.primitives.{StorageLensArn, IsEnabled, ConfigId}
import scala.jdk.CollectionConverters._
final case class StorageLensConfiguration(
    id: ConfigId,
    accountLevel: zio.aws.s3control.model.AccountLevel,
    include: Optional[zio.aws.s3control.model.Include] = Optional.Absent,
    exclude: Optional[zio.aws.s3control.model.Exclude] = Optional.Absent,
    dataExport: Optional[zio.aws.s3control.model.StorageLensDataExport] =
      Optional.Absent,
    isEnabled: IsEnabled,
    awsOrg: Optional[zio.aws.s3control.model.StorageLensAwsOrg] =
      Optional.Absent,
    storageLensArn: Optional[StorageLensArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.StorageLensConfiguration = {
    import StorageLensConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.StorageLensConfiguration
      .builder()
      .id(ConfigId.unwrap(id): java.lang.String)
      .accountLevel(accountLevel.buildAwsValue())
      .optionallyWith(include.map(value => value.buildAwsValue()))(_.include)
      .optionallyWith(exclude.map(value => value.buildAwsValue()))(_.exclude)
      .optionallyWith(dataExport.map(value => value.buildAwsValue()))(
        _.dataExport
      )
      .isEnabled(IsEnabled.unwrap(isEnabled): java.lang.Boolean)
      .optionallyWith(awsOrg.map(value => value.buildAwsValue()))(_.awsOrg)
      .optionallyWith(
        storageLensArn.map(value =>
          StorageLensArn.unwrap(value): java.lang.String
        )
      )(_.storageLensArn)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.StorageLensConfiguration.ReadOnly =
    zio.aws.s3control.model.StorageLensConfiguration.wrap(buildAwsValue())
}
object StorageLensConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.StorageLensConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.StorageLensConfiguration =
      zio.aws.s3control.model.StorageLensConfiguration(
        id,
        accountLevel.asEditable,
        include.map(value => value.asEditable),
        exclude.map(value => value.asEditable),
        dataExport.map(value => value.asEditable),
        isEnabled,
        awsOrg.map(value => value.asEditable),
        storageLensArn.map(value => value)
      )
    def id: ConfigId
    def accountLevel: zio.aws.s3control.model.AccountLevel.ReadOnly
    def include: Optional[zio.aws.s3control.model.Include.ReadOnly]
    def exclude: Optional[zio.aws.s3control.model.Exclude.ReadOnly]
    def dataExport
        : Optional[zio.aws.s3control.model.StorageLensDataExport.ReadOnly]
    def isEnabled: IsEnabled
    def awsOrg: Optional[zio.aws.s3control.model.StorageLensAwsOrg.ReadOnly]
    def storageLensArn: Optional[StorageLensArn]
    def getId: ZIO[Any, Nothing, ConfigId] = ZIO.succeed(id)
    def getAccountLevel
        : ZIO[Any, Nothing, zio.aws.s3control.model.AccountLevel.ReadOnly] =
      ZIO.succeed(accountLevel)
    def getInclude
        : ZIO[Any, AwsError, zio.aws.s3control.model.Include.ReadOnly] =
      AwsError.unwrapOptionField("include", include)
    def getExclude
        : ZIO[Any, AwsError, zio.aws.s3control.model.Exclude.ReadOnly] =
      AwsError.unwrapOptionField("exclude", exclude)
    def getDataExport: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.StorageLensDataExport.ReadOnly
    ] = AwsError.unwrapOptionField("dataExport", dataExport)
    def getIsEnabled: ZIO[Any, Nothing, IsEnabled] = ZIO.succeed(isEnabled)
    def getAwsOrg: ZIO[
      Any,
      AwsError,
      zio.aws.s3control.model.StorageLensAwsOrg.ReadOnly
    ] = AwsError.unwrapOptionField("awsOrg", awsOrg)
    def getStorageLensArn: ZIO[Any, AwsError, StorageLensArn] =
      AwsError.unwrapOptionField("storageLensArn", storageLensArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.StorageLensConfiguration
  ) extends zio.aws.s3control.model.StorageLensConfiguration.ReadOnly {
    override val id: ConfigId =
      zio.aws.s3control.model.primitives.ConfigId(impl.id())
    override val accountLevel: zio.aws.s3control.model.AccountLevel.ReadOnly =
      zio.aws.s3control.model.AccountLevel.wrap(impl.accountLevel())
    override val include: Optional[zio.aws.s3control.model.Include.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.include())
        .map(value => zio.aws.s3control.model.Include.wrap(value))
    override val exclude: Optional[zio.aws.s3control.model.Exclude.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclude())
        .map(value => zio.aws.s3control.model.Exclude.wrap(value))
    override val dataExport
        : Optional[zio.aws.s3control.model.StorageLensDataExport.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataExport())
        .map(value => zio.aws.s3control.model.StorageLensDataExport.wrap(value))
    override val isEnabled: IsEnabled =
      zio.aws.s3control.model.primitives.IsEnabled(impl.isEnabled())
    override val awsOrg
        : Optional[zio.aws.s3control.model.StorageLensAwsOrg.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsOrg())
        .map(value => zio.aws.s3control.model.StorageLensAwsOrg.wrap(value))
    override val storageLensArn: Optional[StorageLensArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageLensArn())
        .map(value => zio.aws.s3control.model.primitives.StorageLensArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.StorageLensConfiguration
  ): zio.aws.s3control.model.StorageLensConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
