package zio.aws.s3control.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.{JobPriority, JobId}
import scala.jdk.CollectionConverters._
final case class UpdateJobPriorityResponse(
    jobId: JobId,
    priority: JobPriority
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.UpdateJobPriorityResponse = {
    import UpdateJobPriorityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.UpdateJobPriorityResponse
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .priority(JobPriority.unwrap(priority): Integer)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.UpdateJobPriorityResponse.ReadOnly =
    zio.aws.s3control.model.UpdateJobPriorityResponse.wrap(buildAwsValue())
}
object UpdateJobPriorityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.UpdateJobPriorityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.UpdateJobPriorityResponse =
      zio.aws.s3control.model.UpdateJobPriorityResponse(jobId, priority)
    def jobId: JobId
    def priority: JobPriority
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getPriority: ZIO[Any, Nothing, JobPriority] = ZIO.succeed(priority)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.UpdateJobPriorityResponse
  ) extends zio.aws.s3control.model.UpdateJobPriorityResponse.ReadOnly {
    override val jobId: JobId =
      zio.aws.s3control.model.primitives.JobId(impl.jobId())
    override val priority: JobPriority =
      zio.aws.s3control.model.primitives.JobPriority(impl.priority())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.UpdateJobPriorityResponse
  ): zio.aws.s3control.model.UpdateJobPriorityResponse.ReadOnly = new Wrapper(
    impl
  )
}
