package zio.aws.s3control.model
import scala.jdk.CollectionConverters.*
sealed trait BucketCannedACL {
  def unwrap: software.amazon.awssdk.services.s3control.model.BucketCannedACL
}
object BucketCannedACL {
  def wrap(
      value: software.amazon.awssdk.services.s3control.model.BucketCannedACL
  ): zio.aws.s3control.model.BucketCannedACL = value match {
    case software.amazon.awssdk.services.s3control.model.BucketCannedACL.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3control.model.BucketCannedACL.PRIVATE =>
      val r = `private`
      r
    case software.amazon.awssdk.services.s3control.model.BucketCannedACL.PUBLIC_READ =>
      val r = `public-read`
      r
    case software.amazon.awssdk.services.s3control.model.BucketCannedACL.PUBLIC_READ_WRITE =>
      val r = `public-read-write`
      r
    case software.amazon.awssdk.services.s3control.model.BucketCannedACL.AUTHENTICATED_READ =>
      val r = `authenticated-read`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.s3control.model.BucketCannedACL {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketCannedACL =
      software.amazon.awssdk.services.s3control.model.BucketCannedACL.UNKNOWN_TO_SDK_VERSION
  }
  case object `private` extends zio.aws.s3control.model.BucketCannedACL {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketCannedACL =
      software.amazon.awssdk.services.s3control.model.BucketCannedACL.PRIVATE
  }
  case object `public-read` extends zio.aws.s3control.model.BucketCannedACL {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketCannedACL =
      software.amazon.awssdk.services.s3control.model.BucketCannedACL.PUBLIC_READ
  }
  case object `public-read-write`
      extends zio.aws.s3control.model.BucketCannedACL {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketCannedACL =
      software.amazon.awssdk.services.s3control.model.BucketCannedACL.PUBLIC_READ_WRITE
  }
  case object `authenticated-read`
      extends zio.aws.s3control.model.BucketCannedACL {
    override def unwrap
        : software.amazon.awssdk.services.s3control.model.BucketCannedACL =
      software.amazon.awssdk.services.s3control.model.BucketCannedACL.AUTHENTICATED_READ
  }
}
