package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BucketLevel(
    activityMetrics: Optional[zio.aws.s3control.model.ActivityMetrics] =
      Optional.Absent,
    prefixLevel: Optional[zio.aws.s3control.model.PrefixLevel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.BucketLevel = {
    import BucketLevel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.BucketLevel
      .builder()
      .optionallyWith(activityMetrics.map(value => value.buildAwsValue()))(
        _.activityMetrics
      )
      .optionallyWith(prefixLevel.map(value => value.buildAwsValue()))(
        _.prefixLevel
      )
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.BucketLevel.ReadOnly =
    zio.aws.s3control.model.BucketLevel.wrap(buildAwsValue())
}
object BucketLevel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.BucketLevel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.BucketLevel =
      zio.aws.s3control.model.BucketLevel(
        activityMetrics.map(value => value.asEditable),
        prefixLevel.map(value => value.asEditable)
      )
    def activityMetrics
        : Optional[zio.aws.s3control.model.ActivityMetrics.ReadOnly]
    def prefixLevel: Optional[zio.aws.s3control.model.PrefixLevel.ReadOnly]
    def getActivityMetrics
        : ZIO[Any, AwsError, zio.aws.s3control.model.ActivityMetrics.ReadOnly] =
      AwsError.unwrapOptionField("activityMetrics", activityMetrics)
    def getPrefixLevel
        : ZIO[Any, AwsError, zio.aws.s3control.model.PrefixLevel.ReadOnly] =
      AwsError.unwrapOptionField("prefixLevel", prefixLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.BucketLevel
  ) extends zio.aws.s3control.model.BucketLevel.ReadOnly {
    override val activityMetrics
        : Optional[zio.aws.s3control.model.ActivityMetrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activityMetrics())
        .map(value => zio.aws.s3control.model.ActivityMetrics.wrap(value))
    override val prefixLevel
        : Optional[zio.aws.s3control.model.PrefixLevel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prefixLevel())
        .map(value => zio.aws.s3control.model.PrefixLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.BucketLevel
  ): zio.aws.s3control.model.BucketLevel.ReadOnly = new Wrapper(impl)
}
