package zio.aws.s3control.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.s3control.model.primitives.IsEnabled
import scala.jdk.CollectionConverters.*
final case class CloudWatchMetrics(isEnabled: IsEnabled) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3control.model.CloudWatchMetrics = {
    import CloudWatchMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3control.model.CloudWatchMetrics
      .builder()
      .isEnabled(IsEnabled.unwrap(isEnabled): java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.s3control.model.CloudWatchMetrics.ReadOnly =
    zio.aws.s3control.model.CloudWatchMetrics.wrap(buildAwsValue())
}
object CloudWatchMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3control.model.CloudWatchMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.s3control.model.CloudWatchMetrics =
      zio.aws.s3control.model.CloudWatchMetrics(isEnabled)
    def isEnabled: IsEnabled
    def getIsEnabled: ZIO[Any, Nothing, IsEnabled] = ZIO.succeed(isEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.s3control.model.CloudWatchMetrics
  ) extends zio.aws.s3control.model.CloudWatchMetrics.ReadOnly {
    override val isEnabled: IsEnabled =
      zio.aws.s3control.model.primitives.IsEnabled(impl.isEnabled())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3control.model.CloudWatchMetrics
  ): zio.aws.s3control.model.CloudWatchMetrics.ReadOnly = new Wrapper(impl)
}
